--[[ 
    Copyright © FrechDachs93 17.08.2025
    Horn configuration script für Farming Simulator 25
    Steuert auswählbare Hupen über designConfiguration
]]

HornConfig = {}

-- Pflichtfunktion: wird immer benötigt
function HornConfig.prerequisitesPresent(specializations)
    return true
end

-- Registriert nur das Event, das benötigt wird
function HornConfig.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", HornConfig)
end

-- Mapping-Tabelle: Konfig-ID -> Sounddatei
-- [0] = nil bedeutet: Standard-Hupe von Giants wird genutzt
local hornSounds = {
    [0]  = nil, -- Standardhupe von Giants
    [2]  = "sounds/hupen/Babyshark.ogg",
    [3]  = "sounds/hupen/BellaCiao.ogg",
    [4]  = "sounds/hupen/BUZINAAR_1.ogg",
    [5]  = "sounds/hupen/BUZINAAR_2.ogg",
    [6]  = "sounds/hupen/ClapUrHands.ogg",
    [7]  = "sounds/hupen/CoffinDance.ogg",
    [8]  = "sounds/hupen/Feuerwehr.ogg",
    [9]  = "sounds/hupen/FinalCountdown.ogg",
    [10] = "sounds/hupen/Fluit.ogg",
    [11] = "sounds/hupen/Freaks.ogg",
    [12] = "sounds/hupen/HappyBirthday.ogg",
    [13] = "sounds/hupen/HighLow.ogg",
    [14] = "sounds/hupen/Horn_loop.ogg",
    [15] = "sounds/hupen/LevanPolka.ogg",
    [16] = "sounds/hupen/Levels.ogg",
    [17] = "sounds/hupen/Luxury.ogg",
    [18] = "sounds/hupen/MissionImpossible.ogg",
    [19] = "sounds/hupen/Pfeife.ogg",
    [20] = "sounds/hupen/PiratesOfCaribbean.ogg",
    [21] = "sounds/hupen/Rushing.ogg",
    [22] = "sounds/hupen/SavageLove.ogg",
    [23] = "sounds/hupen/SkyHigh.ogg",
    [24] = "sounds/hupen/StillDre.ogg",
    [25] = "sounds/hupen/Western.ogg",
}

-- Hauptfunktion: setzt die richtige Hupe beim Laden
function HornConfig:onPreLoad(savegame)
    -- Config-ID aus den vehicleConfigurations lesen (design8)
    local configurationId = Utils.getNoNil(self.configurations["design16"], 0)
    local soundFile = hornSounds[configurationId]

    if soundFile ~= nil then
        -- bestehende Sounddatei ersetzen
        removeXMLProperty(self.externalSoundsFile.handle, "sounds.honk.sound#file")
        setXMLString(self.externalSoundsFile.handle, "sounds.honk.sound#file", soundFile)
    end
    -- Wenn soundFile = nil -> Standard-Hupe von Giants bleibt unverändert
end