-- EasyChangeTransmissionType
-- Specialization to change transmission type via input action
-- Version 1.0.0.0
-- @author Vector Man
-- @date 2021-12-09
-- copyright (c) Vector Man, All Rights Reserved.

EasyChangeTransmissionType = {}
EasyChangeTransmissionType.ModDirectory = g_currentModDirectory
EasyChangeTransmissionType.Types = {"Automatic", "Manual", "ManualClutch"}
EasyChangeTransmissionType.Spec = nil
local modName = g_currentModName

function EasyChangeTransmissionType.prerequisitesPresent(specializations)
	return true
end

function EasyChangeTransmissionType.registerFunctions(vehicleType)
	SpecializationUtil.registerFunction(vehicleType, "setTransmissionType", EasyChangeTransmissionType.setTransmissionType)
	SpecializationUtil.registerFunction(vehicleType, "Input_TYPE_AUTOMATIC", EasyChangeTransmissionType.Input_TYPE_AUTOMATIC)
end

function EasyChangeTransmissionType.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", EasyChangeTransmissionType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", EasyChangeTransmissionType)
end


function EasyChangeTransmissionType:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
	if self.isClient then
		EasyChangeTransmissionType.Spec = self.spec_EasyChangeTransmissionType
		self:clearActionEventsTable(EasyChangeTransmissionType.Spec.actionEvents)

		if isActiveForInputIgnoreSelection then
			local actionEventId
			-- NEXT_TYPE
			_, actionEventId = self:addActionEvent(EasyChangeTransmissionType.Spec.actionEvents, "NEXT_TYPE", self, EasyChangeTransmissionType.Input_NEXT_TYPE, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_HIGH)
			g_inputBinding:setActionEventTextVisibility(actionEventId, true)
			g_inputBinding:setActionEventText(actionEventId, string.format(g_i18n:getText("action_NEXT_TYPE", modName), g_i18n:getText("ui_gearShiftMode"..EasyChangeTransmissionType.Types[g_gameSettings:getValue("gearShiftMode")])))
			_, actionEventId = InputBinding.registerActionEvent(g_inputBinding, "NEXT_TYPE", self, EasyChangeTransmissionType.Input_NEXT_TYPE, false, true, false, true)
			-- TYPE_AUTOMATIC
			_, actionEventId = self:addActionEvent(EasyChangeTransmissionType.Spec.actionEvents, "TYPE_AUTOMATIC", self, EasyChangeTransmissionType.Input_TYPE_AUTOMATIC, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
			_, actionEventId = InputBinding.registerActionEvent(g_inputBinding, "TYPE_AUTOMATIC", self, EasyChangeTransmissionType.TYPE_AUTOMATIC, false, true, false, true)
			-- TYPE_MANUAL
			_, actionEventId = self:addActionEvent(EasyChangeTransmissionType.Spec.actionEvents, "TYPE_MANUAL", self, EasyChangeTransmissionType.Input_TYPE_MANUAL, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
			_, actionEventId = InputBinding.registerActionEvent(g_inputBinding, "TYPE_MANUAL", self, EasyChangeTransmissionType.Input_TYPE_MANUAL, false, true, false, true)
			-- TYPE_MANUALCLUTCH
			_, actionEventId = self:addActionEvent(EasyChangeTransmissionType.Spec.actionEvents, "TYPE_MANUALCLUTCH", self, EasyChangeTransmissionType.Input_TYPE_MANUALCLUTCH, false, true, false, true, true, nil )
			g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW)
			g_inputBinding:setActionEventTextVisibility(actionEventId, false)
			_, actionEventId = InputBinding.registerActionEvent(g_inputBinding, "TYPE_MANUALCLUTCH", self, EasyChangeTransmissionType.Input_TYPE_MANUALCLUTCH, false, true, false, true)
		end
	end
end

function EasyChangeTransmissionType:onLoad(savegame)
	EasyChangeTransmissionType.Spec = self.spec_EasyChangeTransmissionType
end

function EasyChangeTransmissionType:Input_NEXT_TYPE(actionName, inputValue)
	local currentType = g_gameSettings:getValue("gearShiftMode")
	if currentType < 3 then
		EasyChangeTransmissionType:setTransmissionType(currentType+1)
	else
		EasyChangeTransmissionType:setTransmissionType(1)
	end
end

function EasyChangeTransmissionType:Input_TYPE_AUTOMATIC(actionName, inputValue)
	EasyChangeTransmissionType:setTransmissionType(1)
end

function EasyChangeTransmissionType:Input_TYPE_MANUAL(actionName, inputValue)
	EasyChangeTransmissionType:setTransmissionType(2)
end

function EasyChangeTransmissionType:Input_TYPE_MANUALCLUTCH(actionName, inputValue)
	EasyChangeTransmissionType:setTransmissionType(3)
end

function EasyChangeTransmissionType:setTransmissionType(index) -- 1=Automatic, 2=Manual, 3=ManualClutch
	local actionEvent = EasyChangeTransmissionType.Spec.actionEvents["NEXT_TYPE"]
	if g_gameSettings:getValue("gearShiftMode") ~= index then
		g_gameSettings:setValue("gearShiftMode", index)
		if actionEvent ~= nil then
			g_inputBinding:setActionEventText(actionEvent.actionEventId, string.format(g_i18n:getText("action_NEXT_TYPE", modName), g_i18n:getText("ui_gearShiftMode"..EasyChangeTransmissionType.Types[g_gameSettings:getValue("gearShiftMode")])))
		end
	end
end