-- ReverseBeacon.lua
-- Laat de beacon(s) automatisch aan gaan als je achteruit rijdt
-- en uit gaan zodra je niet meer in z'n achteruit staat.

ReverseBeacon = {}
local ReverseBeacon_mt = Class(ReverseBeacon)

-- Alleen voertuigen met Motorized + Lights mogen deze spec krijgen
function ReverseBeacon.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations)
       and SpecializationUtil.hasSpecialization(Lights, specializations)
end

function ReverseBeacon.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", ReverseBeacon)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", ReverseBeacon)
end

function ReverseBeacon:onLoad(savegame)
    -- Simpele eigen spec-tabel, geen getOrCreateSpecTable gebruiken
    self.spec_reverseBeacon = {}
end

function ReverseBeacon:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    -- Als deze functies niet bestaan, gewoon niets doen
    if self.setBeaconLightsVisibility == nil or self.getBeaconLightsVisibility == nil then
        return
    end

    -- movingDirection is -1 bij achteruit, 1 bij vooruit
    if self.movingDirection == nil then
        return
    end

    local isReversing = self.movingDirection < 0
    local beaconsOn = self:getBeaconLightsVisibility()

    if isReversing and not beaconsOn then
        -- Achteruit: zwaailampen AAN
        self:setBeaconLightsVisibility(true)
    elseif not isReversing and beaconsOn then
        -- Niet meer achteruit: zwaailampen UIT
        self:setBeaconLightsVisibility(false)
    end
end
