-- JumperCable Event


-- state: "connect" vagy "disconnect"
-- index: 1 vagy 2
--[[function JumperCableEvent.new(vehicle, state, index)
    local self = JumperCableEvent.emptyNew()
    self.vehicle = vehicle
    self.state = state
    self.index = index
    return self
end

function JumperCableEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadString(streamId)
    self.index = streamReadInt8(streamId)
    self:run(connection)
end

function JumperCableEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteString(streamId, self.state)
    streamWriteInt8(streamId, self.index)
end

function JumperCableEvent:run(connection)
    if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
        g_rvbPlayer.setJumperCable(self.vehicle, self.state, self.index, true)
    end
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end
end

function JumperCableEvent.sendEvent(vehicle, state, index, noEventSend)
    if noEventSend == nil or not noEventSend then
        if g_server ~= nil then
            g_server:broadcastEvent(JumperCableEvent.new(vehicle, state, index), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(JumperCableEvent.new(vehicle, state, index))
        end
    end
end
]]

JumperCableEvent = {}
local JumperCableEvent_mt = Class(JumperCableEvent, Event)
InitEventClass(JumperCableEvent, "JumperCableEvent")

function JumperCableEvent.emptyNew()
    return Event.new(JumperCableEvent_mt)
end

function JumperCableEvent.new(donor, state, receiver)
    local self = JumperCableEvent.emptyNew()
    self.donor = donor print("JumperCableEvent.new donor " ..self.donor:getFullName())
    self.receiver = receiver print("JumperCableEvent.new receiver " ..tostring(self.receiver:getFullName()))
    self.state = state print("JumperCableEvent.new state " ..self.state)
    return self
end

function JumperCableEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.donor)
    NetworkUtil.writeNodeObject(streamId, self.receiver)
	streamWriteString(streamId, self.state)
end

function JumperCableEvent:readStream(streamId, connection)
    self.donor = NetworkUtil.readNodeObject(streamId)
    self.receiver = NetworkUtil.readNodeObject(streamId)
	self.state = streamReadString(streamId)
    self:run(connection)
end

function JumperCableEvent:run(connection)
    if self.state == "connect" then
		print("JumperCableEvent run connect")
		self.donor:connectJumperCable(self.receiver, true)
    elseif self.state == "disconnect" then
		print("JumperCableEvent run disconnect")
        self.receiver:disconnectJumperCable(true)
	elseif self.state == "forceDisconnect" then
		print("JumperCableEvent run forceDisconnect")
        self.donor:forceDisconnectJumperCable(true)
    end

    if not connection:getIsServer() then print("JumperCableEvent run not connection:getIsServer()")
        g_server:broadcastEvent(self, false, connection, self.donor)
    end
end


function JumperCableEvent.sendEvent(donor, state, receiver, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then print("JumperCableEvent sendEvent g_server")
			g_server:broadcastEvent(JumperCableEvent.new(donor, state, receiver), nil, nil, donor)
		else print("JumperCableEvent sendEvent g_client")
			g_client:getServerConnection():sendEvent(JumperCableEvent.new(donor, state, receiver))
		end
    end
end
