
RVBMenu = {}
local RVBMenu_mt = Class(RVBMenu, TabbedMenu)

function RVBMenu.register()
	--2025 RVBnewMenuEmptyFrame.register()
	RVBMenuSettingsFrame.register()
	RVBMenuPartsSettingsFrame.register()
	--RVBMenuHelperFrame.register()
	local v2 = RVBMenu.new()
	g_gui:loadGui(g_vehicleBreakdownsDirectory .. "gui/RVBMenu.xml", "RVBMenu", v2)
	return v2
end
function RVBMenu.new(p3, p4)
	local self = RVBMenu:superClass().new(p3, p4 or RVBMenu_mt)
	self.client = nil
	self.server = nil
	self.isMasterUser = false
	self.isServer = false
	self.pageMain = nil
	self.playerFarm = nil
	self.playerFarmId = 0
	self.pageEmpty = nil
	self.pageSettings = nil
	self.pageHelper = nil
	self.pagePartsSettings = nil
	self.missionInfo = {}
	self.missionDynamicInfo = {}
	self.isSaving = false
	self.continueEnabled = true
	self.currentDeviceHasNoSpace = false
	self.pageSave = nil
	self.defaultMenuButtonInfo = {}
	self.backButtonInfo = {}
	self.blockNextPageNextEvent = false
	return self
end
function RVBMenu.exitMenu(p63)
	if p63.continueEnabled and not p63.isSaving then
		RVBMenu:superClass().exitMenu(p63)
	end
end
function RVBMenu.onGuiSetupFinished(self)
	RVBMenu:superClass().onGuiSetupFinished(self)
	g_messageCenter:subscribe(MessageType.MASTERUSER_ADDED, self.onMasterUserAdded, self)
	self:initializePages()
	self:setupMenuPages()
end

function RVBMenu.initializePages(self)
	self.clickBackCallback = self:makeSelfCallback(self.onButtonBack)

	--2025 self.pageEmpty:initialize()
	self.pageSettings:initialize()
	self.pagePartsSettings:initialize()
	--self.pageHelper:initialize()
	if Platform.hasInGameMenuMainPage then
		--p28.pageMain:initialize()
	end
	
end

function RVBMenu.createFromExistingGui(gui, guiName)

	--2025 RVBnewMenuEmptyFrame.createFromExistingGui(g_gui.frames.rvbnewMenuEmpty.target, "RVBnewMenuEmptyFrame")
	RVBMenuSettingsFrame.createFromExistingGui(g_gui.frames.rvbMenuSettings.target, "RVBMenuSettingsFrame")
	--RVBMenuHelperFrame.createFromExistingGui(g_gui.frames.rvbMenuHelper.target, "RVBMenuHelperFrame")
	RVBMenuPartsSettingsFrame.createFromExistingGui(g_gui.frames.rvbMenuPartsSettings.target, "RVBMenuPartsSettingsFrame")
	local rvbmenu = RVBMenu.new()
	g_gui.guis.RVBMenu:delete()
	g_gui.guis.RVBMenu.target:delete()
	g_gui:loadGui(gui.xmlFilename, guiName, rvbmenu)
	local cMission = g_currentMission
	rvbmenu:setEnvironment(cMission.environment)
	rvbmenu:setClient(g_client)
	rvbmenu:setServer(g_server)
	rvbmenu:setMissionInfo(cMission.missionInfo, cMission.missionDynamicInfo, cMission.baseDirectory)
	--rvbmenu:setInGameMap(cMission.hud:getIngameMap())
	--rvbmenu:setPlayerFarm(gui.playerFarm) print("createFromExistingGui")
	g_rvbMenu = rvbmenu
	return rvbmenu
end

function RVBMenu.setInGameMap(p10, p11)
	if Platform.isMobile then
		--p10.pageMapMobile:setInGameMap(p11)
	else
		 --2025 p10.pageEmpty:setInGameMap(p11)
	end
	p10.baseIngameMap = p11
end
function RVBMenu.setEnvironment(p43, p44)
	 --2025 p43.pageEmpty:setEnvironment(p44)
end
function RVBMenu.setClient(p18, client)
	p18.client = client
	 --2025 p18.pageEmpty:setClient(p19)
end
function RVBMenu.setServer(p20, server)
	p20.server = server
	p20.isServer = server ~= nil
	p20:updateHasMasterRights()
end
function RVBMenu.updateHasMasterRights(p22)
	local hasMasterRights = p22.isMasterUser or p22.isServer
	if Platform.isMobile then
		--p22.pageSettingsMobile:setHasMasterRights(hasMasterRights)
	else
		p22.pageSettings:setHasMasterRights(hasMasterRights)
		--p22.pageHelper:setHasMasterRights(hasMasterRights)
		--p22.pageSave:setHasMasterRights(hasMasterRights)
	end
	if p22.currentPage ~= nil then
		p22:updatePages()
	end
end
function RVBMenu.setPlayerFarm(p49, p50)
	p49.playerFarm = p50
	if p50 == nil then
		p49.playerFarmId = 0
	else
		p49.playerFarmId = p50.farmId
	end
	--2025 p49.pageEmpty:setPlayerFarm(p50)
	if p50 ~= nil and p49:getIsOpen() then
		p49:updatePages()
	end
end
function RVBMenu.updatePages(p87, p88)
	p87.header:setVisible(true)
	if p88 ~= nil then
		local v89 = p87.pagingElement:getPageElementByIndex(p88)
		local v90 = p87.pagingElement:getPageElementByIndex(p87.currentPageId)
		--if v90 == p87.pageMain then
		--	p87.header:setVisible(false)
		--	p87:setPageEnabled(ClassUtil.getClassObjectByObject(p87.pageMain), true)
		--elseif Platform.isMobile and v90 == p87.pageMapMobile then
		--	p87.header:setVisible(false)
		--elseif v89 == p87.pageMain then
		--	p87:setPageEnabled(ClassUtil.getClassObjectByObject(p87.pageMain), false)
		--	p87.pagingElement.currentPageMappingIndex = p87.pagingElement.currentPageMappingIndex - 1
		--elseif v89 == p87.pageHelpLine then
		--	p87:setPageEnabled(ClassUtil.getClassObjectByObject(p87.pageHelpLine), false)
		--elseif v89 == p87.pageSettings then
		if v89 == p87.pageSettings then
			p87:setPageEnabled(ClassUtil.getClassObjectByObject(p87.pageSettings), false)
		--elseif v89 == p87.pageHelper then
		--	p87:setPageEnabled(ClassUtil.getClassObjectByObject(p87.pageHelper), false)
		end
	end
	RVBMenu:superClass().updatePages(p87)
end
function RVBMenu.setMissionInfo(self, missionInfo, missionDynamicInfo, _)
	self.missionInfo = missionInfo
	self.missionDynamicInfo = missionDynamicInfo
	if Platform.isMobile then
		--self.pageSettingsMobile:setMissionInfo(missionInfo)
	else
		self.pageSettings:setMissionInfo(missionInfo)
		--self.pageHelper:setMissionInfo(missionInfo)
	end
	self.currentDeviceHasNoSpace = false
end


function RVBMenu.setupMenuButtonInfo(self)
	RVBMenu:superClass().setupMenuButtonInfo(self)
	local onButtonBackFunction = self.clickBackCallback
	local onButtonPagePrevious = self:makeSelfCallback(self.onPagePrevious)
	local onButtonPageNext = self:makeSelfCallback(self.onPageNext)
	self.backButtonInfo = {
		["inputAction"] = InputAction.MENU_BACK,
		["text"] = g_i18n:getText("button_back"),
		["callback"] = onButtonBackFunction
	}
	self.nextPageButtonInfo = {
		["inputAction"] = InputAction.MENU_PAGE_NEXT,
		["text"] = g_i18n:getText("ui_ingameMenuNext"),
		["callback"] = self.onPageNext
	}
	self.prevPageButtonInfo = {
		["inputAction"] = InputAction.MENU_PAGE_PREV,
		["text"] = g_i18n:getText("ui_ingameMenuPrev"),
		["callback"] = self.onPagePrevious
	}
	if Platform.isMobile then
		self.defaultMenuButtonInfo = { self.backButtonInfo }
	else
		self.defaultMenuButtonInfo = { self.backButtonInfo, self.nextPageButtonInfo, self.prevPageButtonInfo }
	end
	self.defaultMenuButtonInfoByActions[InputAction.MENU_BACK] = self.defaultMenuButtonInfo[1]
	self.defaultMenuButtonInfoByActions[InputAction.MENU_PAGE_PREV] = self.defaultMenuButtonInfo[2]
	self.defaultMenuButtonInfoByActions[InputAction.MENU_PAGE_NEXT] = self.defaultMenuButtonInfo[3]
	self.defaultButtonActionCallbacks = {
		[InputAction.MENU_BACK] = onButtonBackFunction,
		[InputAction.MENU_PAGE_PREV] = onButtonPagePrevious,
		[InputAction.MENU_PAGE_NEXT] = onButtonPageNext
	}
end

function RVBMenu.setupMenuPages(self)
	local v_u_31 = 1
	local function v37(p32, p33, p34, p35)
		if p32 == nil then
			local v36 = self.pagingElement:getPageElementByIndex(v_u_31)
			self.pagingElement:removePageByElement(v36)
		else
			self:registerPage(p32, v_u_31, p33)
			self:addPageTab(p32, nil, nil, p34, p35)
			v_u_31 = v_u_31 + 1
		end
	end
	--2025 v37(self.pageEmpty, self:makeIsStatisticsEnabledPredicate(), "gui.icon_vehicleDealer_machines", "statistics")
	v37(self.pageSettings, self:makeIsStatisticsEnabledPredicate(), "gui.icon_ingameMenu_options", "settings")
	--v37(self.pageHelper, self:makeIsStatisticsEnabledPredicate(), "gui.icon_ingameMenu_options", "helper")
v37(self.pagePartsSettings, self:makeIsStatisticsEnabledPredicate(), "gui.icon_options_gameSettings2", "partssettings")
	
	self:rebuildTabList()
end

function RVBMenu.makeIsStatisticsEnabledPredicate(self)
	return function()
		local v175 = not self.missionDynamicInfo.isMultiplayer or self.playerFarmId ~= FarmManager.SPECTATOR_FARM_ID
		if v175 then
			v175 = not g_guidedTourManager:getIsTourRunning()
		end
		return v175
	end
end
function RVBMenu.makeIsSettingsEnabledPredicate(_)
	return function()
		return false
	end
end
function RVBMenu.onButtonBack(self)
	local v75 = self.currentPage
	if Platform.isMobile then
		local v76 = Utils.getNoNil(v75.closeMenuOneshot, false)
		local v77 = Utils.getNoNil(v75.goToMainOverview, true)
		v75.closeMenuOneshot = false
		if v76 or not v77 then
			RVBMenu:superClass().onButtonBack(self)
		else
			self:setPageEnabled(ClassUtil.getClassObjectByObject(self.pageSettings), true)
			self:goToPage(self.pageSettings)
		end
	else
		if self.currentPage:requestClose(self.clickBackCallback) then
			--if self.currentPage == self.pageSettings then --or self.currentPage == self.pageHelpLine then
			--	self:openGeneralSettingsScreen()
			--	return
			--end
			RVBMenu:superClass().onButtonBack(self)
		end
		return
	end
end
function RVBMenu.onMasterUserAdded(p120, p121)
	if p121:getId() == g_currentMission.playerUserId then
		p120.isMasterUser = true
		p120:updateHasMasterRights()
	end
end
function RVBMenu.onMasterUserRemoved(p122, p123)
	if p123:getId() == g_currentMission.playerUserId then
		p122.isMasterUser = false
		p122:updateHasMasterRights()
	end
end
function RVBMenu.onClickMenu(p124)
	p124:exitMenu()
	return true
end
function RVBMenu.onPageNext(self)
	if self.blockNextPageNextEvent then
		self.blockNextPageNextEvent = false
	elseif self.currentPage:requestClose(self.frameClosePageNextCallback) then
		--if self.currentPage == self.pageSettings then--or self.currentPage == self.pageHelpLine then
		--	self:openGameSettingsScreen()
		--end
		TabbedMenu:superClass().onPageNext(self)
	end
end
function RVBMenu.onPagePrevious(self)
	if self.currentPage:requestClose(self.frameClosePagePreviousCallback) then
		--if self.currentPage == self.pageSettings then --or self.currentPage == self.pageHelpLine then
		--	self:openGameSettingsScreen()
		--end
		TabbedMenu:superClass().onPagePrevious(self)
	end
end
--[[function RVBMenu.onOpenVehicleOverview(p101)
	p101:changeScreen("RVBMenu")
	local v102 = p101.pagingElement:getPageMappingIndexByElement(p101.pageEmpty)
	p101.pageSelector:setState(v102, true)
	p101.pageEmpty:onClickVehicleOverview()
end]]
function RVBMenu.openGameSettingsScreen(p111, _)
	if not p111:getIsOpen() then
		p111:changeScreen("RVBMenu")
	end
	p111:setPageEnabled(ClassUtil.getClassObjectByObject(p111.pageSettings), true)
	local v112 = p111.pagingElement:getPageMappingIndexByElement(p111.pageSettings)
	p111.pageSelector:setState(v112, true)
	p111.pageSettings:onClickGameSettings()
end
function RVBMenu.openGeneralSettingsScreen(p109)
	if not p109:getIsOpen() then
		p109:changeScreen("RVBMenu")
	end
	p109:setPageEnabled(ClassUtil.getClassObjectByObject(p109.pageSettings), true)
	local v110 = p109.pagingElement:getPageMappingIndexByElement(p109.pageSettings)
	p109.pageSelector:setState(v110, true)
	p109.pageSettings:onClickGeneralSettings()
end
--[[function RVBMenu.openSaveScreen(p115)
	if not p115:getIsOpen() then
		p115:changeScreen("RVBMenu")
	end
	p115:setPageEnabled(ClassUtil.getClassObjectByObject(p115.pageSave), true)
	local v116 = p115.pagingElement:getPageMappingIndexByElement(p115.pageSave)
	p115.pageSelector:setState(v116, true)
end]]